jQuery(function ($) {
    'use strict';

    // Функція для перевірки доступності API та налаштувань
    function checkDeliverySetup() {
        if (typeof ipDelivery === 'undefined') {
            console.error('Delivery: ipDelivery object is not defined');
            return false;
        }
        if (!ipDelivery.ajaxUrl) {
            console.error('Delivery: ajaxUrl is not defined');
            return false;
        }
        return true;
    }

    // Глобальний стан
    let deliveryState = {
        initialized: false,
        currentMethod: ''
    };

    // Функція для ініціалізації полів вибору доставки
    function initDeliveryFields(ajaxUrl, translations) {
        if (!checkDeliverySetup()) {
            return;
        }

        // Перевіряємо наявність елементів на сторінці
        if (!$('#delivery_checkout_field').length) {
            console.error('Delivery: checkout fields not found');
            return;
        }

        // Знаходимо обраний метод доставки
        const currentMethod = $('input[name^="shipping_method"]:checked').val();
        console.log('Delivery: Current shipping method:', currentMethod);

        // Якщо вже ініціалізовано і метод доставки не змінився - виходимо
        if (deliveryState.initialized && deliveryState.currentMethod === currentMethod) {
            console.log('Delivery: Already initialized for this method');
            return;
        }

        // Оновлюємо стан
        deliveryState.currentMethod = currentMethod;

        // Якщо не Delivery - очищаємо поля і виходимо
        if (currentMethod !== 'delivery') {
            clearDeliveryFields();
            return;
        }

        // Показуємо блок полів
        $('#delivery_checkout_field').show();

        // Блокуємо поля міста та відділення
        $('#city').prop('disabled', true);
        $('#warehouses').prop('disabled', true);

        // Отримуємо регіони тільки якщо ще не ініціалізовано
        if (!deliveryState.initialized) {
            // Отримуємо регіони
            $.ajax({
                url: ajaxUrl,
                type: 'POST',
                data: {
                    action: 'delivery_get_areas',
                },
                success: function (response) {
                    if (response.success) {
                        let areas = response.data;
                        $('#delivery').find('option').remove();
                        $('#delivery').append($("<option></option>", {
                            value: 0,
                            text: translations.selectRegion
                        }));

                        // Перевіряємо різні формати даних
                        let areasList = [];

                        if (areas && typeof areas === 'object') {
                            if (areas.data && Array.isArray(areas.data)) {
                                areasList = areas.data;
                            } else if (areas.Data && Array.isArray(areas.Data)) {
                                areasList = areas.Data;
                            } else if (Array.isArray(areas)) {
                                areasList = areas;
                            }

                            if (areasList.length > 0) {
                                for (let i = 0; i < areasList.length; i++) {
                                    const area = areasList[i];
                                    const id = area.Id || area.id || area.ID;
                                    const name = area.Name || area.name || area.NAME;

                                    if (id && name) {
                                        $('#delivery').append($("<option></option>", {
                                            value: id,
                                            text: name
                                        }));
                                    }
                                }
                                deliveryState.initialized = true;
                            } else {
                                alert(translations.noRegions);
                            }
                        } else {
                            alert(translations.invalidData);
                        }
                    } else {
                        alert(translations.errorLoadingRegions);
                    }
                },
                error: function (xhr, status, error) {
                    alert(translations.serverError);
                }
            });
        }
    }

    // Функція очищення полів доставки
    function clearDeliveryFields() {
        $('#delivery_checkout_field').hide();
        $('#delivery').find('option').remove().end().append($("<option></option>", {
            value: 0,
            text: ipDelivery.translations.selectRegion
        }));
        $('#city').prop('disabled', true).find('option').remove().end().append($("<option></option>", {
            value: 0,
            text: ipDelivery.translations.selectCity
        }));
        $('#warehouses').prop('disabled', true).find('option').remove().end().append($("<option></option>", {
            value: 0,
            text: ipDelivery.translations.selectWarehouse
        }));
        deliveryState.initialized = false;
    }

    // Обробник зміни регіону
    $(document).on('change', '#delivery', function () {
        if (this.value == 0) return;

        // Отримуємо міста за регіоном
        $.ajax({
            url: ipDelivery.ajaxUrl,
            type: 'POST',
            data: {
                action: 'delivery_get_cities',
                area_id: this.value
            },
            success: function (response) {
                if (response.success) {
                    let cities = response.data;
                    $('#city').prop('disabled', false);
                    $('#city').find('option').remove();
                    $('input[name="delivery_delivery_name"]').val($('#delivery').find('option:selected').text());
                    $('#city').append($("<option></option>", {
                        value: 0,
                        text: ipDelivery.translations.selectCity
                    }));

                    if (Array.isArray(cities)) {
                        for (let i = 0; i < cities.length; i++) {
                            $('#city').append($("<option></option>", {
                                value: cities[i].id || cities[i].Id || cities[i].ID,
                                text: cities[i].name || cities[i].Name || cities[i].NAME
                            }));
                        }
                    } else if (cities && cities.data && Array.isArray(cities.data)) {
                        for (let i = 0; i < cities.data.length; i++) {
                            $('#city').append($("<option></option>", {
                                value: cities.data[i].id || cities.data[i].Id || cities.data[i].ID,
                                text: cities.data[i].name || cities.data[i].Name || cities.data[i].NAME
                            }));
                        }
                    }
                }
            }
        });
    });

    // Обробник зміни міста
    $(document).on('change', '#city', function () {
        if (this.value == 0) return;

        // Отримуємо відділення за містом
        $.ajax({
            url: ipDelivery.ajaxUrl,
            type: 'POST',
            data: {
                action: 'delivery_get_warehouses',
                city_id: this.value
            },
            success: function (response) {
                if (response.success) {
                    let warehouses = response.data;
                    $('#warehouses').prop('disabled', false);
                    $('#warehouses').find('option').remove();
                    $('input[name="delivery_city_name"]').val($('#city').find('option:selected').text());
                    $('#warehouses').append($("<option></option>", {
                        value: 0,
                        text: ipDelivery.translations.selectWarehouse
                    }));

                    if (Array.isArray(warehouses)) {
                        for (let i = 0; i < warehouses.length; i++) {
                            let address = warehouses[i].address || warehouses[i].Address || warehouses[i].ADDRESS || '';
                            let name = warehouses[i].name || warehouses[i].Name || warehouses[i].NAME || '';
                            $('#warehouses').append($("<option></option>", {
                                value: warehouses[i].id || warehouses[i].Id || warehouses[i].ID,
                                text: name + ' (' + address + ')'
                            }));
                        }
                    } else if (warehouses && warehouses.data && Array.isArray(warehouses.data)) {
                        for (let i = 0; i < warehouses.data.length; i++) {
                            let address = warehouses.data[i].address || warehouses.data[i].Address || warehouses.data[i].ADDRESS || '';
                            let name = warehouses.data[i].name || warehouses.data[i].Name || warehouses.data[i].NAME || '';
                            $('#warehouses').append($("<option></option>", {
                                value: warehouses.data[i].id || warehouses.data[i].Id || warehouses.data[i].ID,
                                text: name + ' (' + address + ')'
                            }));
                        }
                    }
                }
            }
        });
    });

    // Обробник зміни відділення
    $(document).on('change', '#warehouses', function () {
        $('input[name="delivery_warehouses_name"]').val($(this).find('option:selected').text());
    });

    // Обробник зміни способу доставки
    $(document).on('change', 'input[name^="shipping_method"]', function () {
        initDeliveryFields(ipDelivery.ajaxUrl, ipDelivery.translations);
        $('body').trigger('update_checkout');
    });

    // Обробник оновлення checkout
    $(document).on('updated_checkout', function () {
        initDeliveryFields(ipDelivery.ajaxUrl, ipDelivery.translations);
    });

    // Ініціалізація при завантаженні з затримкою
    setTimeout(function () {
        console.log('Delivery: Initial initialization');
        initDeliveryFields(ipDelivery.ajaxUrl, ipDelivery.translations);
    }, 500);

    // Повторна перевірка через 2 секунди після завантаження
    setTimeout(function () {
        console.log('Delivery: Secondary check');
        if ($('input[name^="shipping_method"]:checked').val() === 'delivery' && !deliveryState.initialized) {
            console.log('Delivery: Forcing initialization');
            initDeliveryFields(ipDelivery.ajaxUrl, ipDelivery.translations);
        }
    }, 2000);

    // Валідація перед відправкою форми
    $(document).on('checkout_place_order', function () {
        if ($('input[name^="shipping_method"]:checked').val() === 'delivery') {
            var region = $('#delivery').val();
            var city = $('#city').val();
            var warehouse = $('#warehouses').val();

            if (region == '0' || region == undefined) {
                alert(ipDelivery.translations.pleaseSelectRegion);
                $('#delivery').focus();
                return false;
            }

            if (city == '0' || city == undefined) {
                alert(ipDelivery.translations.pleaseSelectCity);
                $('#city').focus();
                return false;
            }

            if (warehouse == '0' || warehouse == undefined) {
                alert(ipDelivery.translations.pleaseSelectWarehouse);
                $('#warehouses').focus();
                return false;
            }
        }
    });
});